<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>{{ $title . ' | ' . $appName }}</title>
    <link rel="stylesheet" href="{{ asset('front_end/classic/css/enews-paper.css') }}?v=<?= time() ?>">
    <style>
        :root {
            --enews-bg-image: url('{{ asset('storage/' . $e_newspaper->thumbnail) }}');
        }
    </style>
</head>

<body>
    <!-- Hidden div with PDF path -->
    <div id="pdf-data-holder" data-pdf-url="{{ asset('storage/' . $e_newspaper->pdf_path) }}"></div>

    <div class="container">

        <div class="loading active" id="loading"></div>

        <div class="flipbook-wrapper">
            <div id="flipbook"></div>

            <!-- Left Arrow -->
            <button class="nav-arrow" id="prevArrow" aria-label="Previous page">
                <svg viewBox="0 0 24 24">
                    <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z" />
                </svg>
            </button>

            <!-- Right Arrow -->
            <button class="nav-arrow" id="nextArrow" aria-label="Next page">
                <svg viewBox="0 0 24 24">
                    <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z" />
                </svg>
            </button>
        </div>

        <div class="page-counter" id="pageCounter">
            Page <span id="currentPage">1</span> of <span id="totalPagesDisplay">1</span>
        </div>
    </div>

    <!-- Libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/turn.js/3/turn.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script src="{{ asset('front_end/classic/js/custom/enews-paper.js') }}"></script>
</body>

</html>
